//
// (c) 2024 wesolutions GmbH
// All rights reserved.
//

import QtQml 2.12
import QtQuick 2.12
import QtQuick.Window 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiPopupAnchor {
    id : popupEditor

    property Component component

    readonly property Item editor :
        popupVisible && popupItem ? popupItem.editor : null

    property real horizontalOffset : 0
    property real verticalOffset : 4
    property int padding : 10

    onAboutToHide : popupItem.discard()

    popup : UiTooltipAgent {
        id : popup_

        readonly property real capLeft : -(popupEditor.distanceLeft - 10)
        readonly property real capRight :
            popupEditor.distanceRight - popup_.width - 10

        readonly property real horizontalOffset : {
            // Move left to item center, modified by offset
            let offset = -(width / 2 - popupEditor.horizontalOffset);

            // Adapt to fit left cap
            offset = Math.max(offset, capLeft);

            // Adapt to fit right cap
            offset = Math.min(offset, capRight);

            return offset;
        }

        readonly property Item editor : popupContent.item
        property bool flipped :
            popupEditor.distanceBottom < popupEditor.distanceTop

        property real maxHeight :
            flipped
            ? popupEditor.distanceTop - 20 - verticalOffset
            : popupEditor.distanceBottom - 20 - verticalOffset

        function discard() {
            discardAnimation.start();
        }

        implicitWidth : popupContent.implicitWidth + 2 * padding
        implicitHeight : Math.min(maxHeight,
                                  popupContent.implicitHeight + 2 * padding)
        x : horizontalOffset

        anchors.bottomMargin : popupEditor.verticalOffset
        anchors.topMargin : popupEditor.verticalOffset

        NumberAnimation {
            property : "opacity"
            running : true
            from : 0
            to : 1
            target : popup_
        }

        SequentialAnimation {
            id : discardAnimation

            ScriptAction {
                script : {
                    // Break bindings
                    popup_.flipped = popup_.flipped;
                    popup_.maxHeight = popup_.maxHeight;
                }
            }
            NumberAnimation {
                property : "opacity"
                to : 0
                target : popup_
            }
        }

        states : [
            State {
                name : "normal"
                when : !popup_.flipped

                AnchorChanges {
                    target : popup_
                    anchors.top : parent ? parent.bottom : undefined
                    anchors.bottom : undefined
                }
                PropertyChanges {
                    target : popup_
                }
            },
            State {
                name : "flipped"
                when : popup_.flipped

                AnchorChanges {
                    target : popup_
                    anchors.top : undefined
                    anchors.bottom : parent ? parent.top : undefined
                }
                PropertyChanges {
                    target : popup_
                }
            }
        ]

        UiPopupBackground {
            id : content

            anchors.fill : popup_
            peakOffset : -horizontalOffset
            flipped : popup_.flipped

            Loader {
                id : popupContent

                sourceComponent : popupEditor.component

                anchors {
                    fill : parent || null
                    margins : popupEditor.padding
                }
            }
        }
    }
}
